/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusContainer;

public abstract class NavigationPoint
implements StatusContainer {
    private NavigationDestination destination;
    private String label;
    private String id;
    private NavigationPoint parent;
    private NavigationContext navContext;

    public NavigationPoint() {
        this("");
    }

    public NavigationPoint(String string) {
        this(string, null);
    }

    public NavigationPoint(String string, NavigationDestination navigationDestination) {
        this(string, navigationDestination, null);
    }

    public NavigationPoint(String string, NavigationDestination navigationDestination, String string2) {
        this.setLabel(string);
        this.setDestination(navigationDestination);
        this.setId(string2);
        this.parent = null;
        this.navContext = new NavigationContext();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    protected NavigationPoint getParent() {
        return this.parent;
    }

    protected void setParent(NavigationPoint navigationPoint) {
        this.parent = navigationPoint;
        if (navigationPoint == null) {
            this.navContext.setParent(null);
            return;
        }
        this.navContext.setParent(navigationPoint.getNavContext());
    }

    public void setDestination(NavigationDestination navigationDestination) {
        this.destination = navigationDestination;
    }

    public NavigationDestination getDestination() {
        return this.destination;
    }

    public NavigationPoint findId(String string) {
        if (this.id == null) {
            return null;
        }
        if (this.id.equals(string)) {
            return this;
        }
        return null;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.navContext.setParent(null);
    }

    public void removeChild(NavigationPoint navigationPoint) {
        navigationPoint.setParent(null);
        navigationPoint.navContext.setParent(null);
    }

    public NavigationContext getNavContext() {
        return this.navContext;
    }

    public void dispose() {
        this.destination = null;
        this.parent = null;
        this.navContext = null;
    }

    public abstract Status getStatus();
}

